//
//  B5ItemFileReference.h
//  ApplicationFrameworks
//
//  Created by Rick Fillion on 2016-05-12.
//
//

#import <Foundation/Foundation.h>
@class OPSymmetricKey;

@interface B5ItemFileReference : NSObject

+ (instancetype)referenceWithFileIdentifier:(NSString *)fileIdentifier signingKey:(OPSymmetricKey *)signingKey;
- (instancetype)initWithFileIdentifier:(NSString *)fileIdentifier signingKey:(OPSymmetricKey *)signingKey;

@property (nonatomic, readonly, copy) NSString *fileIdentifier;
@property (nonatomic, readonly, strong) OPSymmetricKey *signingKey;

- (NSString *)signReferenceToItemUUID:(NSString *)itemUUID itemVersion:(NSUInteger)itemVersion;

@end
